package kom.itbeankit.common.itbeanframe;

import java.awt.*;
import java.awt.image.*;
import java.net.*;

public class ItDrawImage extends java.awt.Canvas
{
    //{{DECLARE_CONTROLS

    protected Image theImage;
	protected URL theUrl;

    //}}

	public ItDrawImage()
	{

	}


	public ItDrawImage(String imagefile)
	{
		setBackground(new Color(12632256));
		theImage = loadImage(imagefile);
	}


   protected Image loadImage(String filename){
       try {
          theUrl = getClass().getResource(filename);
          return createImage((ImageProducer) theUrl.getContent());
       }catch (Exception exp1) {
          System.out.println("Image " + filename + " does not exist");
          return null;
       }
    }

    public synchronized void paint (Graphics g){
      Dimension dim = this.getSize();
      int imageW = theImage.getWidth(null);
      int imageH = theImage.getHeight(null);

      g.drawImage(theImage, dim.width/2-imageW/2, dim.height/2-imageH/2, this);
    }

}